#!/bin/bash
# 
## usage:  sbatch ./submit_cpu.sh
#
#SBATCH -J mpi  
#SBATCH -N 1
#SBATCH -p zen3_0512
#SBATCH --qos zen3_0512 
##SBATCH --reservation training_cpu
#SBATCH --time 0-00:10:00 

module purge
module load intel-oneapi-mkl/2022.2.1-gcc-9.5.0-o75fxps
module load arm/25.0.4_FORGE

SIMPLEPATH=$FORGE_TRAINING/correctness/debug/simple

# Debug a simple MPI program
ddt --offline -o offline-debugging.html --break-at=simple.c:32 --break-at=simple.c:41 mpirun -np 4 $SIMPLEPATH
